@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Manage Cases')
@section('vendor-style')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apex-charts.scss',
  // 'resources/assets/vendor/libs/swiper/swiper.scss'
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',

  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'
])
@endsection

@section('page-style')
@vite([
  // 'resources/assets/vendor/scss/pages/cards-statistics.scss',
  // 'resources/assets/vendor/scss/pages/cards-analytics.scss'
])
@endsection

@section('vendor-script')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apexcharts.js',
  // 'resources/assets/vendor/libs/swiper/swiper.js'

  'resources/assets/vendor/libs/select2/select2.js',

  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
])
@endsection

@section('page-script')
@vite(['resources/assets/js/chain-select.js'])
@vite('resources/assets/js/app-invoice-list.js')
<script type="module">
  window.addEventListener('load', function() {
    if (typeof $ === 'undefined' || typeof $.fn.select2 === 'undefined') return;

    $('.select2').each(function () {
      var $this = $(this);
      if ($this.hasClass('select2-hidden-accessible')) return;

      var isAjaxSearch = $this.data('ajax-search') === true;
      var container = $this.parent();
      container.css('position', container.css('position') === 'static' ? 'relative' : container.css('position'));
      var config = {
        placeholder: $this.data('placeholder') || 'Select value',
        dropdownParent: container,
        width: '100%'
      };

      if (isAjaxSearch) {
        config.ajax = {
          url: '/api/ajax-search',
          dataType: 'json',
          delay: 250,
          transport: function(params, success, failure) {
            if (!params.data || !params.data.search || params.data.search.length < 1) {
              success({ results: [], pagination: { more: false } });
              return;
            }
            var $request = $.ajax(params);
            $request.then(success).fail(failure);
            return $request;
          },
          data: function (params) {
            var data = {
              search: params.term || '',
              page: params.page || 1,
              model: $this.data('ajax-model'),
              display: $this.data('ajax-display'),
              key: $this.data('ajax-key'),
              limit: $this.data('ajax-limit') || 20
            };
            var dependsOn = $this.data('depends-on');
            var filterColumn = $this.data('filter-column');
            if (dependsOn && filterColumn) {
              var parentSelect = document.querySelector('select[name="' + dependsOn + '"], select[name="' + dependsOn + '[]"]');
              if (parentSelect) {
                var parentValue = parentSelect.multiple
                  ? Array.from(parentSelect.selectedOptions).map(opt => opt.value).filter(v => v !== '')
                  : parentSelect.value;
                if (parentValue && (Array.isArray(parentValue) ? parentValue.length > 0 : parentValue !== '')) {
                  data.filterColumn = filterColumn;
                  data.filterValue = parentValue;
                }
              }
            }
            return data;
          },
          processResults: function (data) {
            return data && data.results ? { results: data.results, pagination: { more: data.pagination.more } } : { results: [], pagination: { more: false } };
          },
          cache: false
        };
        config.minimumInputLength = 1;
        config.allowClear = true;
      }

      $this.select2(config);
    });
  });
</script>
@endsection

@section('content')
<div class="row g-4">



  <!-- Header Card -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">

        <div class="row g-3 align-items-start">

          <div class="col-md-3">
            <h4 class="card-title mb-2">Manage Cases</h4>
            <p class="mb-0">List edit and search cases here.</p>
          </div>

          <div class="col-md-9">
            <div class="demo-inline-spacing d-flex flex-wrap gap-2">
              <button type="button" class="btn rounded-pill btn-primary">All</button>
              <button type="button" class="btn rounded-pill btn-danger">Add Record</button>
              <button type="button" class="btn rounded-pill btn-secondary">Head Notes</button>
              <button type="button" class="btn rounded-pill btn-info">Judgment</button>
              <button type="button" class="btn rounded-pill btn-warning">Export cases</button>
              <button type="button" class="btn rounded-pill btn-dark">Get Case ID</button>

              <button type="button" class="btn btn-secondary waves-effect waves-light">
              <span class="tf-icons ri-notification-4-line ri-16px me-2"></span>Secondary
            </button>


            </div>
          </div>


        </div>

      </div>
    </div>
  </div>
  <!--/ Header Card -->





    <!-- Header Card -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">


         <div class="row mb-3">

                <div class="col-md-6 mb-6">
                    <x-form.input name="subject" label="Subject" placeholder="Enter subject" class="form-group"/>
                </div>
                <div class="col">
                    <x-form.input name="fyear" label="From year/vol" placeholder="From year/vol" class="form-group" />
                </div>
                <div class="col">
                    <x-form.input name="tyear" label="To year/vol" placeholder="To year/vol" class="form-group" />
                </div>
                <div class="col-md-2 mb-2">


                                    <x-form.select
                                        name="mag"
                                        model="App\Models\CmsMagazine"
                                        {{-- :query="[['orderBy',['mag_name','asc']]]" --}}
                                        display="mag_name"
                                        key="mag_id"
                                        label="Select Mgazine"
                                        placeholder="Select Magzine"
                                        class="form-control select2"
                                        id="magzine"
                                        data-placeholder="Select Magzine"
                                        />


                </div>

                <div class="col">
                     <button type="button" class="btn rounded-pill btn-primary form-control">Search</button>
                </div>

            </div>





            <!-- Invoice List Table -->
<div class="card">
  <div class="card-datatable table-responsive">
    <table class="invoice-list-table table">
      <thead>
        <tr>
          <th></th>
          <th></th>
          <th>#ID</th>
          <th>#</th>
          <th>Client</th>
          <th>Total</th>
          <th class="text-truncate">Issued Date</th>
          <th>Balance</th>
          <th>Invoice Status</th>
          <th class="cell-fit">Actions</th>
        </tr>
      </thead>
    </table>
  </div>
</div>




<!-- Form Start -->


<!-- Form End-->









      </div>
    </div>
  </div>
  <!--/ Header Card -->













</div>
@endsection
